/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

public class TileAnimatedTorch
extends TileMod
implements IManaTrigger,
IWandable {
    private static final String TAG_SIDE = "side";
    private static final String TAG_ROTATING = "rotating";
    private static final String TAG_ROTATION_TICKS = "rotationTicks";
    private static final String TAG_ANGLE_PER_TICK = "anglePerTick";
    private static final String TAG_TORCH_MODE = "torchMode";
    private static final String TAG_NEXT_RANDOM_ROTATION = "nextRandomRotation";
    public static final Direction[] SIDES = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public int side;
    public double rotation;
    public boolean rotating;
    public double lastTickRotation;
    public int nextRandomRotation = Mth.m_14107_((double)(Math.random() * 3.0));
    public int currentRandomRotation;
    private int rotationTicks;
    public double anglePerTick;
    private TorchMode torchMode = TorchMode.TOGGLE;

    public TileAnimatedTorch(BlockPos pos, BlockState state) {
        super(ModTiles.ANIMATED_TORCH, pos, state);
    }

    public void handRotate() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7696_(this.m_58899_(), ModBlocks.animatedTorch, 0, (this.side + 1) % 4);
        }
    }

    public void onPlace(@Nullable LivingEntity entity) {
        if (entity != null) {
            this.side = Arrays.asList(SIDES).indexOf(entity.m_6350_().m_122424_());
        }
        this.f_58857_.m_46672_(this.m_58899_().m_142300_(SIDES[this.side].m_122424_()), this.m_58900_().m_60734_());
    }

    public void toggle() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7696_(this.m_58899_(), ModBlocks.animatedTorch, 0, this.torchMode.modeSwitcher.rotate(this, this.side));
            this.nextRandomRotation = this.f_58857_.f_46441_.nextInt(4);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public boolean onUsedByWand(Player player, ItemStack stack, Direction side) {
        int modeOrdinal = this.torchMode.ordinal();
        TorchMode[] modes = TorchMode.values();
        this.torchMode = modes[(modeOrdinal + 1) % modes.length];
        return true;
    }

    public boolean m_7531_(int id, int param) {
        if (id == 0) {
            this.rotateTo(param);
            return true;
        }
        return super.m_7531_(id, param);
    }

    private void rotateTo(int side) {
        if (this.rotating) {
            return;
        }
        this.currentRandomRotation = this.nextRandomRotation;
        int finalRotation = side * 90;
        double diff = ((double)finalRotation - this.rotation % 360.0) % 360.0;
        if (diff < 0.0) {
            diff = 360.0 + diff;
        }
        this.rotationTicks = 4;
        this.anglePerTick = diff / (double)this.rotationTicks;
        this.side = side;
        this.rotating = true;
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        for (Direction e : Direction.values()) {
            this.f_58857_.m_46672_(this.m_58899_().m_142300_(e), this.m_58900_().m_60734_());
        }
    }

    @Override
    public void onBurstCollision(IManaBurst burst) {
        if (!burst.isFake()) {
            this.toggle();
        }
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, TileAnimatedTorch self) {
        if (self.rotating) {
            self.lastTickRotation = self.rotation;
            self.rotation = (self.rotation + self.anglePerTick) % 360.0;
            --self.rotationTicks;
            if (self.rotationTicks <= 0) {
                self.rotating = false;
                level.m_46672_(worldPosition, state.m_60734_());
                for (Direction e : Direction.values()) {
                    level.m_46672_(worldPosition.m_142300_(e), state.m_60734_());
                }
            }
        } else {
            self.rotation = self.side * 90;
        }
        if (level.f_46443_) {
            int amt = self.rotating ? 3 : (Math.random() < 0.1 ? 1 : 0);
            double x = (double)worldPosition.m_123341_() + 0.5 + Math.cos((self.rotation + 90.0) / 180.0 * Math.PI) * 0.35;
            double y = (double)worldPosition.m_123342_() + 0.2;
            double z = (double)worldPosition.m_123343_() + 0.5 + Math.sin((self.rotation + 90.0) / 180.0 * Math.PI) * 0.35;
            for (int i = 0; i < amt; ++i) {
                level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_SIDE, this.side);
        cmp.m_128379_(TAG_ROTATING, this.rotating);
        cmp.m_128405_(TAG_ROTATION_TICKS, this.rotationTicks);
        cmp.m_128347_(TAG_ANGLE_PER_TICK, this.anglePerTick);
        cmp.m_128405_(TAG_TORCH_MODE, this.torchMode.ordinal());
        cmp.m_128405_(TAG_NEXT_RANDOM_ROTATION, this.nextRandomRotation);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.side = cmp.m_128451_(TAG_SIDE);
        this.rotating = cmp.m_128471_(TAG_ROTATING);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.rotationTicks = cmp.m_128451_(TAG_ROTATION_TICKS);
        }
        this.anglePerTick = cmp.m_128459_(TAG_ANGLE_PER_TICK);
        this.nextRandomRotation = cmp.m_128451_(TAG_NEXT_RANDOM_ROTATION);
        int modeOrdinal = cmp.m_128451_(TAG_TORCH_MODE);
        TorchMode[] modes = TorchMode.values();
        this.torchMode = modes[modeOrdinal % modes.length];
    }

    public static enum TorchMode {
        TOGGLE((t, i) -> (i + 2) % 4),
        ROTATE((t, i) -> (i + 1) % 4),
        RANDOM((t, i) -> t.currentRandomRotation);

        public final RotationHandler modeSwitcher;

        private TorchMode(RotationHandler modeSwitcher) {
            this.modeSwitcher = modeSwitcher;
        }

        private static interface RotationHandler {
            public int rotate(TileAnimatedTorch var1, int var2);
        }
    }

    public static class WandHud
    implements IWandHUD {
        private final TileAnimatedTorch torch;

        public WandHud(TileAnimatedTorch torch) {
            this.torch = torch;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            int x = mc.m_91268_().m_85445_() / 2 + 10;
            int y = mc.m_91268_().m_85446_() / 2 - 8;
            mc.m_91291_().m_115203_(new ItemStack((ItemLike)Blocks.f_50174_), x, y);
            mc.f_91062_.m_92750_(ms, I18n.m_118938_((String)("botania.animatedTorch." + this.torch.torchMode.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]), (float)(x + 18), (float)(y + 6), 0xFF4444);
        }
    }
}

